/** @file   SentryFireballBullet.cpp
 * @brief   Implementation of SentryFireballBullet class.
 * @version $Revision: 1.2 $
 * @date    $Date: 2006/02/08 21:47:24 $
 * @author  Tomi Lamminsaari
 */

#include "SentryFireballBullet.h"
#include "www_map.h"
#include "gameanims.h"
#include "AnimId.h"
using namespace eng2d;


namespace WeWantWar {

///
/// Constructors, destructor and operators
/// ============================================================================

/** Default constructor.
 */
SentryFireballBullet::SentryFireballBullet( GameObject* aShooter,
                                            const Vec2D& aPos ) :
  Bullet( aShooter, Bullet::ESentryFireball, aPos )
{
  iAnimation = GameAnims::findAnimation( AnimId::KBulletAlienFireball );
}



/** Destructor.
 */
SentryFireballBullet::~SentryFireballBullet()
{
}



///
/// Methods inhertited from the base class(es)
/// ============================================================================

/** Draws this bullet
 */
void SentryFireballBullet::redraw( BITMAP* aBitmap ) const
{
  int posX = iPosition.intX() - Map::scrollX;
  int posY = iPosition.intY() - Map::scrollY;
  RLE_SPRITE* gfx = iAnimation.currentFrame().asRleSprite();
  posX -= gfx->w / 2;
  posY -= gfx->h / 2;
  draw_rle_sprite( aBitmap, gfx, posX, posY );
}

};  // end of namespace
